<aside id="sidebar" class="sidebar">
  <ul class="sidebar-nav" id="sidebar-nav">
    <li class="nav-item">
      <a class="nav-link" href="<?php echo e(route('home')); ?>">
        <i class="bi bi-grid"></i>
        <span>Dashboard</span>
      </a>
    </li>
    <!-- End Dashboard Nav -->

    <?php if(auth()->user()->user_type == 'chair'): ?>
      <li class="nav-heading">Metrics & Scores</li>
      <!-- metric input -->
      <li class="nav-item">
        <a class="nav-link collapsed" href="<?php echo e(route('metrics.index')); ?>">
          <i class="bi bi-list-check"></i><span>Metrics</span>
        </a>
      </li>
      <!-- assign scores -->
      <li class="nav-item">
        <a class="nav-link collapsed" href="<?php echo e(route('assign_scores.create')); ?>">
          <i class="bi bi-calculator"></i><span>Scores</span>
        </a>
      </li>
      <!-- key programmes -->
      <li class="nav-item">
        <a class="nav-link collapsed" href="<?php echo e(route('programmes.index')); ?>">
          <i class="bi bi-tag"></i><span>Programs</span>
        </a>
      </li>
      <!-- score cards -->
      <li class="nav-item">
        <a class="nav-link collapsed" href="<?php echo e(route('score_cards.index')); ?>">
          <i class="bi bi-kanban"></i><span>Rating Scale</span>
        </a>
      </li>
      <!-- teams -->
      <li class="nav-item">
        <a class="nav-link collapsed" href="<?php echo e(route('teams.index')); ?>">
          <i class="bi bi-people"></i><span>Teams</span>
        </a>
      </li>

      <!-- Reports -->
      <li class="nav-heading">Report Center</li>
      <li class="nav-item">
        <a class="nav-link collapsed" href="<?php echo e(route('reports.metric_summary')); ?>">
          <i class="bi bi-circle"></i><span>Program Metrics Summary</span>
        </a>
        <a class="nav-link collapsed" href="<?php echo e(route('reports.team_size_summary')); ?>">
          <i class="bi bi-circle"></i><span>Team Size Summary</span>
        </a>
        <a class="nav-link collapsed" href="<?php echo e(route('reports.monthly_pledge')); ?>">
          <i class="bi bi-circle"></i><span>Monthly Pledge Vs Actual</span>
        </a>
        <a class="nav-link collapsed" href="<?php echo e(route('reports.monthly_pledge_vs_mission')); ?>">
          <i class="bi bi-circle"></i><span>Monthly Pledge & Mission</span>
        </a>
        <a class="nav-link collapsed" href="<?php echo e(route('reports.score_variance')); ?>">
          <i class="bi bi-circle"></i><span>Score Variance</span>
        </a>
        <a class="nav-link collapsed" href="<?php echo e(route('reports.team_summary_performance')); ?>">
          <i class="bi bi-circle"></i><span>Performance Summary</span>
        </a>
        <a class="nav-link collapsed" href="<?php echo e(route('reports.team_report_card')); ?>">
          <i class="bi bi-circle"></i><span>Team Report Card</span>
        </a>
      </li>
      
      <li class="nav-heading">Settings</li>
      <!-- user management -->
      <li class="nav-item">
        <a class="nav-link collapsed" href="<?php echo e(route('user_profiles.index')); ?>">
          <i class="bi bi-person-lines-fill"></i><span>Users</span>
        </a>
      </li>
      <!-- settings -->
      <li class="nav-item">
        <a class="nav-link collapsed" href="<?php echo e(route('config.general_settings')); ?>">
          <i class="bi bi-gear-fill"></i><span>General</span>
        </a>
      </li>
    <?php endif; ?>

    
    <!-- captain and member menus -->
    <?php if(in_array(auth()->user()->user_type, ['captain', 'member'])): ?>
      <li class="nav-heading">Metrics & Scores</li>
      <!-- metric input -->
      <li class="nav-item">
        <a class="nav-link collapsed" href="<?php echo e(route('metrics.index')); ?>">
          <i class="bi bi-list-check"></i><span>Metrics</span>
        </a>
      </li>
      <?php if(in_array(auth()->user()->user_type, ['captain'])): ?>
        <!-- teams -->
        <li class="nav-item">
          <a class="nav-link collapsed" href="<?php echo e(route('teams.index')); ?>">
            <i class="bi bi-people"></i><span>Teams</span>
          </a>
        </li>
      <?php endif; ?>

      <!-- Reports -->
      <li class="nav-heading">Report Center</li>
      <li class="nav-item">
        <a class="nav-link collapsed" href="<?php echo e(route('reports.metric_summary')); ?>">
          <i class="bi bi-circle"></i><span>Metric Summary</span>
        </a>
        <a class="nav-link collapsed" href="<?php echo e(route('reports.team_size_summary')); ?>">
          <i class="bi bi-circle"></i><span>Team Size Summary</span>
        </a>
        

        <!-- Team Captain Performance Summary Access -->
        <?php
          $currMonth = date('m', strtotime(date('Y-m-d')));
          $accessMonth = date('m', strtotime(auth()->user()->company->pfmance_report_start));
        ?>
        <?php if(auth()->user()->user_type == 'captain' && intval($accessMonth) <= intval($currMonth)): ?>
          <a class="nav-link collapsed" href="<?php echo e(route('reports.team_summary_performance')); ?>">
            <i class="bi bi-circle"></i><span>Performance Summary</span>
          </a>
        <?php endif; ?>
        
        <a class="nav-link collapsed" href="<?php echo e(route('reports.team_report_card')); ?>">
          <i class="bi bi-circle"></i><span>Team Report Card</span>
        </a>
      </li>
    <?php endif; ?>
  </ul>
</aside>
<?php /**PATH /home/dojotech/public_html/lopmetrics.dojotechsolutions.com/resources/views/layouts/sidebar_menu.blade.php ENDPATH**/ ?>