<?php $__env->startSection('title', 'Team Management'); ?>
    
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('teams.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="card">
        <div class="card-body">
            <div class="card-content p-2">
                <div class="mb-2">
                    <?php if(auth()->user()->user_type === 'chair'): ?>
                        <span class="badge bg-primary" data-bs-toggle="modal" data-bs-target="#verifxnModal" style="cursor: pointer;">
                            Verify Teams <i class="bi bi-caret-down-fill"></i>
                        </span>                    
                    <?php endif; ?>
                </div>
                <div class="table-responsive">
                    <table class="table table-borderless datatable">
                        <thead>
                          <tr>
                            <th>#No.</th>
                            <th>#Serial</th>
                            <th>Team Label</th>
                            <th>Local Size</th>
                            <th>Diasp. Size</th>
                            <th>Dorm. Size</th>
                            <th>Status</th>
                            <th>Updated At</th>
                            <th>Action</th>
                          </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $teamSize = optional($team->teamSizesForPeriod(date('m'), date('Y'))->first()) ?>
                                <tr>
                                    <th scope="row"><?php echo e($i+1); ?></th>
                                    <th><?php echo e(tidCode('', $team->tid)); ?></th>
                                    <td><?php echo e($team->name); ?></td>
                                    <td><?php echo e($teamSize->local_size); ?></td>
                                    <td><?php echo e($teamSize->diaspora_size); ?></td>
                                    <td><?php echo e($teamSize->dormant_size); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo e($teamSize->verified? 'success' : 'secondary'); ?>">
                                            <?php echo e($teamSize->verified? 'Verified' : 'Unverified'); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e(dateFormat($team->updated_at, 'd-m-Y')); ?></td>
                                    <td><?php echo $team->action_buttons; ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('teams.modals.verification_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    const Index = {
        initRow: $('.temp-row'),

        init() {
            $('.temp-row').remove();

            $('#month, #year').change(Index.onChangePeriod);
            $('#month').change();
            
            $('#teamSizeTbl').on('change', '.verified-check', Index.onChangeVerified);
        },

        onChangePeriod() {
            $('#teamSizeTbl tbody').html('');
            $.post("<?php echo e(route('verification_teams')); ?>", {
                month: $('#month').val(),
                year: $('#year').val(),
            })
            .then(resp => {
                if (resp.length) {
                    resp.forEach(team => {
                        const teamSize = team.team_size || {};
                        const date = teamSize?.start_period || '';
                        const row = Index.initRow.clone();
                        row.find('.name').html(team.name);
                        row.find('.date').html(date.split('-').reverse().join('-'));
                        row.find('.local-size').html(teamSize.local_size);
                        row.find('.diasp-size').html(teamSize.diaspora_size);
                        row.find('.dorm-size').html(teamSize.dormant_size);
                        row.find('.verified').val(teamSize.verified? 1 : '');
                        row.find('.verified-check').attr('checked', teamSize.verified? true : false);
                        row.find('.note').html(teamSize.verified_note);
                        row.find('.id').val(teamSize.id);
                        $('#teamSizeTbl tbody').append(row);
                    });
                }
            })
            .fail((xhr,status,err) => console.log(err))
        },

        onChangeVerified() {
            const tr = $(this).closest('tr');
            if ($(this).prop('checked')) {
                tr.find('.verified').val(1);
            } else {
                tr.find('.verified').val('');
            }
        },
    }
    $(Index.init);
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.core', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dojotech/public_html/lopmetrics.dojotechsolutions.com/resources/views/teams/index.blade.php ENDPATH**/ ?>