<div class="modal fade" id="verifxnModal" tabindex="-1" aria-labelledby="verifxnModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="verifxnModalLabel">Verify Team Composition</h1>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <?php echo e(Form::open(['route' => 'verify_teams', 'id' => 'verifxForm'])); ?>

        <div class="modal-body">
          <div class="row mb-3">
            <div class="col-sm-8">
              <label for="colFormLabel" class="col-sm-2 col-form-label">Period</label>
              <?php
                $currentYear = date('Y');
                $endYear = $currentYear - 10;
                $years = [];
                for ($year = $currentYear; $year >= $endYear; $year--) {
                  $years[] = $year;
                }
                $months = [
                  'January', 'February', 'March', 'April', 'May', 'June',
                  'July', 'August', 'September', 'October', 'November', 'December'
                ];
              ?>
              <div class="d-flex gap-3">
                <select id="month" class="form-control w-50">
                  <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($i+1); ?>" <?php echo e(date('F') === $month? 'selected' : ''); ?>><?php echo e($month); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <select id="year" class="form-control w-50">
                  <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($year); ?>" <?php echo e(date('Y') === $year? 'selected' : ''); ?> ><?php echo e($year); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>                  
              </div>              
            </div>
          </div>
          <div class="input-group">
            <label for="colFormLabel" class="col-sm-2 col-form-label">Composition</label>
          </div>
          <div class="table-responsive">
            <table id="teamSizeTbl" class="table table-bordered table-sm">
              <thead>
                  <tr>
                      <th>Team Name</th>
                      <th>As Of Date</th>
                      <th>Local Size</th>
                      <th>Diaspora Size</th>
                      <th>Dormant Size</th>
                      <th>Verified</th>
                      <th>Note</th>
                  </tr>
              </thead>
              <tbody>
                  <tr class="temp-row">
                    <td class="name" width="20%"></td>
                    <td class="date" width="15%"></td>
                    <td class="local-size"></td>
                    <td class="diasp-size"></td>
                    <td class="dorm-size"></td>
                    <td class="d-flex justify-content-center align-items-center">
                      <input type="checkbox" class="form-check-input verified-check">
                      <input type="hidden" name="verified[]" class="verified">
                    </td>                        
                    <td><textarea name="verified_note[]" class="form-control note" rows="1"></textarea></td>
                    <input type="hidden" name="id[]" class="id">
                  </tr> 
              </tbody>
            </table>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Save changes</button>
        </div>
      <?php echo e(Form::close()); ?>

      </div>    
    </div>
  </div>
</div><?php /**PATH /home/dojotech/public_html/lopmetrics.dojotechsolutions.com/resources/views/teams/modals/verification_modal.blade.php ENDPATH**/ ?>