<?php

namespace App\Models\team;

use App\Models\team\Traits\TeamMemberRelationship;
use Illuminate\Database\Eloquent\Model;

class TeamMember extends Model
{
    use TeamMemberRelationship;
    /**
     * The database table used by the model.
     * @var string
     */
    protected $table = 'team_members';

    /**
     * Mass Assignable fields of model
     * @var array
     */
    protected $fillable = [];

    /**
     * Default values for model fields
     * @var array
     */
    protected $attributes = [];

    /**
     * Dates
     * @var array
     */
    protected $dates = [
        'created_at',
        'updated_at'
    ];

    /**
     * Guarded fields of model
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    /**
     * Constructor of Model
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($instance) {
            $instance->user_id = auth()->user()->id;
            $instance->ins = auth()->user()->ins;
            return $instance;
        });
    }

    // custom attributes
    public function getIsCategoryMemberVerifiedAttribute()
    {
        $category = $this->attributes['category'];
        return $this->verify_members()->where('category',  $category)->exists();
    }
}
