<?php

namespace App\Models\role;

use App\Models\ModelTrait;
use App\Models\role\Traits\RoleAttribute;
use App\Models\role\Traits\RoleRelationship;
use Illuminate\Database\Eloquent\Model;

class Role extends Model
{
    use ModelTrait, RoleAttribute, RoleRelationship;    

    /**
     * The database table used by the model.
     * @var string
     */
    protected $table = 'roles';

    /**
     * Mass Assignable fields of model
     * @var array
     */
    protected $fillable = [];

    /**
     * Default values for model fields
     * @var array
     */
    protected $attributes = [];

    /**
     * Dates
     * @var array
     */
    protected $dates = [
        'created_at',
        'updated_at'
    ];

    /**
     * Guarded fields of model
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    /**
     * Constructor of Model
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    protected static function boot()
    {
        parent::boot();
    }
}
